unit Form_SMTP_ICS;

{$I DICompilers.inc} // DIHtmlParser installed? Download from http://www.yunqa.de

interface

uses
  DISystemCompat, Classes, Forms, Controls, Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons,
  // Ancestor Base Form
  form_SMTP_Base,
  // ICS - Download from http://www.overbyte.be/
  SmtpProt,
  // DIHtmlMimeMessage
  DIHtmlMimeMessage;

type
  TfrmSmtpICS = class(TfrmSmtpBase)
    procedure FormCreate(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure DIHtmlMimeMessage1Attachment(
      const Sender: TDIHtmlMimeMessage;
      const AFullFileName, AFileExt: UnicodeString;
      var AContentID: UnicodeString;
      const TagID, AttribId: Cardinal;
      var AttachFile: Boolean);
    procedure DIHtmlMimeMessage1End(
      const AHtmlBuf: Pointer;
      const AHtmlBufSize: Cardinal);
  private
    FHtmlSmtpCli: THtmlSmtpCli;
    FNumber: Integer;
    FRunning: Boolean;
    procedure OnHtmlSmtpCli_RequestDone(Sender: TObject; RqType: TSmtpRequest; ErrorCode: Word);
    procedure OnHtmlSmtpCli_SessionClosed(Sender: TObject; ErrCode: Word);
  public

  end;

var
  frmSmtpICS: TfrmSmtpICS;

implementation

{$R *.DFM}

uses
  SysUtils, TypInfo, DIUtils;

procedure TfrmSmtpICS.FormCreate(Sender: TObject);
var
  t: TSmtpAuthType;
begin
  FHtmlSmtpCli := THtmlSmtpCli.Create(Self);
  FHtmlSmtpCli.OnRequestDone := OnHtmlSmtpCli_RequestDone;
  FHtmlSmtpCli.OnSessionClosed := OnHtmlSmtpCli_SessionClosed;

  cboSmtpServerAuthType.Clear;
  for t := Low(TSmtpAuthType) to High(TSmtpAuthType) do
    cboSmtpServerAuthType.Items.Add(GetEnumName(TypeInfo(TSmtpAuthType), Ord(t)));
  cboSmtpServerAuthType.ItemIndex := 0;

  inherited;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpICS.btnSendClick(Sender: TObject);
begin
  if FRunning then
    begin
      Status('**** ALREADY RUNNING ****');
      Exit;
    end;

  btnSend.Enabled := False;
  Status('Preparing message ...');

  { Clear SMTP component. }
  FHtmlSmtpCli.EmailImages.Clear;

  { Invoke TDIHtmlMimeMessage to parse the HTML file and call its events. }
  FNumber := 0;
  DIHtmlMimeMessage1.FillFromFile(edtHtmlFileName.Text);

  { Initialize all SMTP component properties from our GUI }
  FHtmlSmtpCli.Host := edtSmtpServerName.Text;
  FHtmlSmtpCli.Port := edtSmtpServerPort.Text;

  FHtmlSmtpCli.AuthType := TSmtpAuthType(cboSmtpServerAuthType.ItemIndex);
  FHtmlSmtpCli.UserName := edtSmtpUserName.Text;
  FHtmlSmtpCli.Password := edtSmtpPassword.Text;

  FHtmlSmtpCli.HdrFrom := edtFrom.Text;
  FHtmlSmtpCli.ConfirmReceipt := chkReturnReciept.Checked;
  FHtmlSmtpCli.HdrTo := edtTo.Text;
  FHtmlSmtpCli.HdrCc := edtCC.Text;

  { Recipient list is computed from To, Cc and Bcc fields }
  FHtmlSmtpCli.RcptName.Clear;
  FHtmlSmtpCli.RcptNameAdd(edtTo.Text, edtCC.Text, edtBCC.Text);

  FHtmlSmtpCli.HdrSubject := edtSubject.Text;

  FHtmlSmtpCli.ContentType := smtpHtml;

  Status('Connecting to SMTP server...');
  { Start first operation to do to send an email. The next operations
    are started from OnRequestDone event (implemented int OnHtmlSmtpClient_RequestDone). }
  FHtmlSmtpCli.Connect
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpICS.DIHtmlMimeMessage1Attachment(
  const Sender: TDIHtmlMimeMessage;
  const AFullFileName, AFileExt: UnicodeString;
  var AContentID: UnicodeString;
  const TagID, AttribId: Cardinal;
  var AttachFile: Boolean);
begin
  { ICS only supports IMAGE1, IMAGE2, etc. CIDs and will discard original
    file names. We must therefore change our AContentID to what ICS supports. }
  Inc(FNumber);
  AContentID := 'IMAGE' + IntToStrW(FNumber);

  { Add the contents of the file as an inline HTML attachment. }
  FHtmlSmtpCli.EmailImages.Add(AFullFileName);
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpICS.DIHtmlMimeMessage1End(
  const AHtmlBuf: Pointer;
  const AHtmlBufSize: Cardinal);
var
  s: AnsiString;
begin
  // FHtmlSmtpCli.PlainText := PlainTextMemo.Lines;
  SetString(s, PAnsiChar(AHtmlBuf), AHtmlBufSize);
  FHtmlSmtpCli.HtmlText.Text := s;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpICS.OnHtmlSmtpCli_RequestDone(Sender: TObject; RqType: TSmtpRequest; ErrorCode: Word);
begin
  { For every operation, we display the status }
  if (ErrorCode > 0) and (ErrorCode < 10000) then
    Status('RequestDone Rq=' + IntToStr(Ord(RqType)) + ' Error=' + FHtmlSmtpCli.ErrorMessage)
  else
    Status('RequestDone Rq=' + IntToStr(Ord(RqType)) + ' Error=' + IntToStr(ErrorCode));

  { Start next operation, but first check if previous one was OK }
  if ErrorCode <> 0 then
    begin
      // FRunning := False; { Terminate All-In-One demo }
      Status('Error, stop.');
      Exit;
    end;

  case RqType of
    smtpConnect:
      begin
        if FHtmlSmtpCli.AuthType = smtpAuthNone then
          FHtmlSmtpCli.Helo
        else
          FHtmlSmtpCli.Ehlo;
      end;

    smtpHelo:
      begin
        FHtmlSmtpCli.MailFrom;
      end;

    smtpEhlo:
      begin
        FHtmlSmtpCli.Auth;
      end;

    smtpAuth:
      begin
        FHtmlSmtpCli.MailFrom;
      end;

    smtpMailFrom:
      begin
        FHtmlSmtpCli.RcptTo;
      end;

    smtpRcptTo:
      begin
        FHtmlSmtpCli.Data;
      end;

    smtpData:
      begin
        FHtmlSmtpCli.Quit;
      end;

    smtpQuit:
      begin
        Status('Done !');
      end;
  end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpICS.OnHtmlSmtpCli_SessionClosed(Sender: TObject; ErrCode: Word);
begin
  Status('Disconnected !');
  btnSend.Enabled := True;
  FRunning := False;
end;

end.

