unit form_SMTP_Base;

{$I DICompilers.inc} // DIHtmlParser installed? Download from http://www.yunqa.de

interface

uses
  {$IFDEF HAS_UNITSCOPE}
  System.Classes, Vcl.Controls, Vcl.Forms, Vcl.StdCtrls, Vcl.ExtCtrls,
  Vcl.ComCtrls, Vcl.Buttons, Vcl.Dialogs,
  {$ELSE HAS_UNITSCOPE}
  Classes, Controls, Forms, StdCtrls, ExtCtrls, ComCtrls, Buttons, Dialogs,
  {$ENDIF HAS_UNITSCOPE}
  DIHtmlMimeMessage;

type
  TfrmSmtpBase = class(TForm)
    StatusBar: TStatusBar;
    PageControl: TPageControl;
    tabMessage: TTabSheet;
    tabSettings: TTabSheet;
    pnlMessage: TPanel;
    Panel1: TPanel;
    pnlRecipient: TPanel;
    lblTo: TLabel;
    edtTo: TEdit;
    lblCC: TLabel;
    lblBCC: TLabel;
    edtCC: TEdit;
    edtBCC: TEdit;
    lblPriority: TLabel;
    cboPriority: TComboBox;
    chkReturnReciept: TCheckBox;
    lblSubject: TLabel;
    edtSubject: TEdit;
    lblHtmlFileName: TLabel;
    edtHtmlFileName: TEdit;
    pnlSmtpSettings: TPanel;
    lblAuthenticationType: TLabel;
    lbAccount: TLabel;
    lbPassword: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    cboSmtpServerAuthType: TComboBox;
    edtSmtpUserName: TEdit;
    edtSmtpPassword: TEdit;
    edtSmtpServerName: TEdit;
    edtSmtpServerPort: TEdit;
    OpenDialog1: TOpenDialog;
    btnOpenFile: TBitBtn;
    btnSend: TBitBtn;
    Label1: TLabel;
    edtFrom: TEdit;
    btnShowHtml: TBitBtn;
    DIHtmlMimeMessage1: TDIHtmlMimeMessage;
    tabOptions: TTabSheet;
    pnlOptions: TPanel;
    cbxStylesInline: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnOpenFileClick(Sender: TObject);
    procedure btnShowHtmlClick(Sender: TObject);
    procedure cbxStylesInlineClick(Sender: TObject);
  private
    procedure ReadConfiguration;
    procedure WriteConfiguration;
  protected
    function GetTitle: string; dynamic;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Status(const s: string);
  end;

var
  frmSmtpBase: TfrmSmtpBase;

implementation

{$R *.DFM}

uses
  {$IFDEF HAS_UNITSCOPE}
  Winapi.Windows, Winapi.ShellAPI, System.SysUtils, System.IniFiles,
  {$ELSE HAS_UNITSCOPE}
  Windows, ShellAPI, SysUtils, IniFiles,
  {$ENDIF HAS_UNITSCOPE}
  DIHtmlParser, DIHtmlCharSetPlugin;

//------------------------------------------------------------------------------

constructor TfrmSmtpBase.Create(AOwner: TComponent);
var
  s: string;
begin
  inherited;
  s := GetTitle;
  Application.Title := s;
  Caption := s;

  {$IFDEF COMPILER_7_UP}
  { Starting with Delphi 7, a new TPanel.ParentBackground property defaults
    to True which suppresses our custom color settings. }
  pnlRecipient.ParentBackground := False;
  pnlMessage.ParentBackground := False;
  pnlSmtpSettings.ParentBackground := False;
  pnlOptions.ParentBackground := False;
  {$ENDIF COMPLIER_7_UP}
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpBase.FormCreate(Sender: TObject);
begin
  ReadConfiguration;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpBase.FormDestroy(Sender: TObject);
begin
  WriteConfiguration;
end;

//------------------------------------------------------------------------------

function TfrmSmtpBase.GetTitle: string;
begin
  Result := 'Send HTML E-Mail via SMTP';
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpBase.ReadConfiguration;
begin
  with TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini')) do
    try
      edtSmtpServerName.Text := ReadString('SMTP', 'ServerName', 'smtp.server.com');
      edtSmtpServerPort.Text := ReadString('SMTP', 'ServerPort', '25');
      cboSmtpServerAuthType.ItemIndex := ReadInteger('SMTP', 'ServerAuthType', 0);
      edtSmtpUserName.Text := ReadString('SMTP', 'ServerUserName', 'your_user_name');
      edtSmtpPassword.Text := ReadString('SMTP', 'ServerPassword', 'your_password');

      edtFrom.Text := ReadString('Mail', 'From', 'your_email_address@server.com');
      edtTo.Text := ReadString('Mail', 'To', 'to@server.com');
      edtCC.Text := ReadString('Mail', 'CC', '');
      edtBCC.Text := ReadString('Mail', 'BCC', '');
      cboPriority.ItemIndex := ReadInteger('Mail', 'Priority', cboPriority.ItemIndex);
      chkReturnReciept.Checked := ReadBool('Mail', 'ReturnReciept', False);

      edtHtmlFileName.Text := ReadString('Mail', 'HtmlFileName', '');
      edtSubject.Text := ReadString('Mail', 'Subject', '');

      cbxStylesInline.Checked := ReadBool('Options', 'StylesInline', DIHtmlMimeMessage1.StylesInline);
    finally
      Free;
    end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpBase.WriteConfiguration;
begin
  with TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini')) do
    try
      WriteString('SMTP', 'ServerName', edtSmtpServerName.Text);
      WriteString('SMTP', 'ServerPort', edtSmtpServerPort.Text);
      WriteInteger('SMTP', 'ServerAuthType', cboSmtpServerAuthType.ItemIndex);
      WriteString('SMTP', 'ServerUserName', edtSmtpUserName.Text);
      WriteString('SMTP', 'ServerPassword', edtSmtpPassword.Text);

      WriteString('Mail', 'From', edtFrom.Text);
      WriteString('Mail', 'To', edtTo.Text);
      WriteString('Mail', 'CC', edtCC.Text);
      WriteString('Mail', 'BCC', edtBCC.Text);
      WriteInteger('Mail', 'Priority', cboPriority.ItemIndex);
      WriteBool('Mail', 'ReturnReciept', chkReturnReciept.Checked);

      WriteString('Mail', 'HtmlFileName', edtHtmlFileName.Text);
      WriteString('Mail', 'Subject', edtSubject.Text);

      WriteBool('Options', 'StylesInline', cbxStylesInline.Checked);
    finally
      Free;
    end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpBase.btnOpenFileClick(Sender: TObject);
begin
  OpenDialog1.FileName := edtHtmlFileName.Text;
  if OpenDialog1.Execute then
    edtHtmlFileName.Text := OpenDialog1.FileName;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpBase.btnShowHtmlClick(Sender: TObject);
begin
  ShellExecute(GetDesktopWindow, 'open', PChar(edtHtmlFileName.Text), nil, nil, SW_SHOWNORMAL);
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpBase.cbxStylesInlineClick(Sender: TObject);
begin
  DIHtmlMimeMessage1.StylesInline := cbxStylesInline.Checked;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpBase.Status(const s: string);
begin
  StatusBar.SimpleText := s;
  StatusBar.Refresh;
end;

//------------------------------------------------------------------------------

initialization
  { IMPORTANT: Register the tags, attributes and entities
    which DIHtmlParser needs to work correctly. }
  RegisterHtmlTags; // In DIHtmlParser.pas.
  RegisterHtmlAttribs; // In DIHtmlParser.pas.
  RegisterHtmlDecodingEntities; // In DIHtmlParser.pas.

  { IMPORTANT: Register the character sets which you want to be detected
    during HTML document parsing. }
  RegisterCharSets; // In DIHtmlCharSetPlugin.pas.
end.

