unit Form_SMTP_Indy;

{$I DICompilers.inc} // DIHtmlParser installed? Download from http://www.yunqa.de

interface

uses
  // Delphi
  DISystemCompat,
  {$IFDEF HAS_UNITSCOPE}
  System.Classes, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.Buttons,
  Vcl.Controls, Vcl.ExtCtrls, Vcl.ComCtrls,
  {$ELSE HAS_UNITSCOPE}
  Classes, Forms, Dialogs, StdCtrls, Buttons, Controls, ExtCtrls, ComCtrls,
  {$ENDIF HAS_UNITSCOPE}
  // Indy - Download from http://www.indyproject.org
  IdText, IdMessage, IdSmtp,
  // Acester Form
  Form_SMTP_Base,
  DIHtmlMimeMessage;

type
  TfrmSmtpIndy = class(TfrmSmtpBase)
    procedure DIHtmlMimeMessage1Attachment(
      const Sender: TDIHtmlMimeMessage;
      const AFullFileName, AFileExt: UnicodeString;
      var AContentID: UnicodeString;
      const TagID, AttribId: Cardinal;
      var Attach: Boolean);
    procedure DIHtmlMimeMessage1End(
      const HtmlBuf: Pointer;
      const HtmlBufSize: Cardinal);
    procedure btnSendClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DIHtmlMimeMessage1Begin;
  private
    FIdMessage: TIdMessage;
    FIdSMTP: TIdSMTP;
    FTextPlain: TidText;
    FTextHtml: TidText;
  end;

var
  frmSmtpIndy: TfrmSmtpIndy;

implementation

uses
  {$IFDEF HAS_UNITSCOPE}
  System.SysUtils, System.TypInfo,
  {$ELSE HAS_UNITSCOPE}
  SysUtils, TypInfo,
  {$ENDIF HAS_UNITSCOPE}
  IdGlobalProtocols, IdAttachmentFile;

{$R *.DFM}

//------------------------------------------------------------------------------

procedure TfrmSmtpIndy.FormCreate(Sender: TObject);
var
  MP: TIdMessagePriority;
begin
  FIdMessage := TIdMessage.Create(Self);
  FIdSMTP := TIdSMTP.Create(Self);

  for MP := Low(TIdMessagePriority) to High(TIdMessagePriority) do
    cboPriority.Items.Add(GetEnumName(TypeInfo(TIdMessagePriority), Ord(MP)));
  cboPriority.ItemIndex := Integer(FIdMessage.Priority);

  inherited;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIndy.btnSendClick(Sender: TObject);
begin
  btnSend.Enabled := False;
  try
    Status('Preparing message ...');
    with FIdMessage do
      begin
        From.Text := edtFrom.Text;
        ReplyTo.EMailAddresses := edtFrom.Text;
        Recipients.EMailAddresses := edtTo.Text;
        CCList.EMailAddresses := edtCC.Text;
        BccList.EMailAddresses := edtBCC.Text;
        Subject := edtSubject.Text;

        if cboPriority.ItemIndex >= 0 then
          Priority := TIdMessagePriority(cboPriority.ItemIndex);

        if chkReturnReciept.Checked then
          ReceiptRecipient.Text := From.Text
        else
          ReceiptRecipient.Text := '';
      end;

    { Call DIIndyHtmlMimeMessage to fill the message with the HTML document and
      all linked files as atatchments. }
    DIHtmlMimeMessage1.FillFromFile(edtHtmlFileName.Text);

    case cboSmtpServerAuthType.ItemIndex of
      0: FIdSMTP.AuthType := satNone;
      1: FIdSMTP.AuthType := satDefault;
    end;

    FIdSMTP.UserName := edtSmtpUserName.Text;
    FIdSMTP.Password := edtSmtpPassword.Text;
    FIdSMTP.Host := edtSmtpServerName.Text;
    FIdSMTP.Port := StrToInt(edtSmtpServerPort.Text);

    {$IFDEF DI_Debug}
    FIdMessage.SaveToFile('c:\temp\Indy_Message.txt');
    {$ENDIF}

    Status('Sending message ...');
    FIdSMTP.Connect;
    try
      FIdSMTP.Send(FIdMessage);
    finally
      FIdSMTP.Disconnect;
    end;
  finally
    Status('');
    btnSend.Enabled := True;
  end;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIndy.DIHtmlMimeMessage1Begin;
begin
  { How to set up plain text and HTML e-mail messages with Indy:
    http://www.projectindy.org/Sockets/Blogs/RLebeau/2005_08_17_A.EN.aspx }

  FIdMessage.ClearBody;
  FIdMessage.MessageParts.Clear;
  FIdMessage.ContentType := 'multipart/related; type="multipart/alternative"';

  { Create an empty message part. Works as a wrapper around the plain text and
    HTML parts. }
  with TidText.Create(FIdMessage.MessageParts) do
    begin
      ContentType := 'multipart/alternative';
    end;

  { Create a plain text part. This is for demonstration only, it is not
    actually used here. }
  FTextPlain := TidText.Create(FIdMessage.MessageParts);
  FTextPlain.ContentType := 'text/plain';
  FTextPlain.ParentPart := 0;
  FTextPlain.Body.Add('This is an HTML message. Upgrade you e-mail client if you can read this!');

  { Now for the HTML part. Text contents is filled in DIHtmlMimeMessage1End. }
  FTextHtml := TidText.Create(FIdMessage.MessageParts);
  FTextHtml.ContentType := 'text/html';
  FTextHtml.ParentPart := 0;
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIndy.DIHtmlMimeMessage1Attachment(
  const Sender: TDIHtmlMimeMessage;
  const AFullFileName, AFileExt: UnicodeString;
  var AContentID: UnicodeString;
  const TagID, AttribId: Cardinal;
  var Attach: Boolean);
var
  NewAttachment: TidAttachmentFile;
begin
  NewAttachment := TidAttachmentFile.Create(FIdMessage.MessageParts, AFullFileName);
  NewAttachment.ContentID := AContentID;
  NewAttachment.ContentType := GetMIMETypeFromFile(AFileExt);
end;

//------------------------------------------------------------------------------

procedure TfrmSmtpIndy.DIHtmlMimeMessage1End(
  const HtmlBuf: Pointer;
  const HtmlBufSize: Cardinal);
var
  s: RawByteString;
begin
  SetString(s, PAnsiChar(HtmlBuf), HtmlBufSize);
  FTextHtml.Body.Text := string(s);
end;

end.

