unit Form_Mapi_Jcl;

{$I DICompilers.inc} // DIHtmlParser installed? Download from http://www.yunqa.de

interface

uses
  DISystemCompat, Classes, Controls, Forms, StdCtrls, ExtCtrls, ComCtrls, Buttons,
  Dialogs,
  // Ancestor Base Form
  form_SMTP_Base,
  // jclMapi - Download from http://jcl.sourceforge.net
  JclMapi,
  // DIHtmlMimeMessage
  DIHtmlMimeMessage;

type
  TfrmJclMapi = class(TfrmSmtpBase)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure DIHtmlMimeMessage1Attachment(
      const Sender: TDIHtmlMimeMessage;
      const AFullFileName, AFileExt: UnicodeString;
      var AContentID: UnicodeString;
      const TagID, AttribId: Cardinal;
      var Attach: Boolean);
    procedure DIHtmlMimeMessage1End(
      const AHtmlBuffer: Pointer;
      const AHtmlBufferSize: Cardinal);
  private
    Mapi: TjclEMail;
  protected
    function GetTitle: string; override;
  end;

var
  frmJclMapi: TfrmJclMapi;

implementation

{$R *.dfm}

procedure TfrmJclMapi.FormCreate(Sender: TObject);
begin
  inherited;
  Mapi := TjclEMail.Create;
  Mapi.HtmlBody := True;
  tabSettings.TabVisible := False;
end;

//------------------------------------------------------------------------------

procedure TfrmJclMapi.FormDestroy(Sender: TObject);
begin
  Mapi.Free;
  inherited;
end;

//------------------------------------------------------------------------------

function TfrmJclMapi.GetTitle: string;
begin
  Result := 'Send HTML E-Mail via MAPI';
end;

//------------------------------------------------------------------------------

procedure TfrmJclMapi.btnSendClick(Sender: TObject);
begin
  inherited;
  if Mapi.AnyClientInstalled then
    begin
      Mapi.Clear;
      DIHtmlMimeMessage1.FillFromFile(edtHtmlFileName.Text);

      {with lbxMapiClients do
        if ItemIndex >= 0 then
          EMail.SelectedClientIndex := ItemIndex;}

      Mapi.Recipients.Add(AnsiString(edtTo.Text), AnsiString(edtTo.Text));
      Mapi.Subject := AnsiString(edtSubject.Text);
      if not Mapi.Send then
        begin
          ShowMessage('Error sending message to MAPI client.');
        end;
    end
  else
    begin
      ShowMessage('No MAPI client installed.');
    end;
end;

//------------------------------------------------------------------------------

procedure TfrmJclMapi.DIHtmlMimeMessage1Attachment(
  const Sender: TDIHtmlMimeMessage;
  const AFullFileName, AFileExt: UnicodeString;
  var AContentID: UnicodeString;
  const TagID, AttribId: Cardinal;
  var Attach: Boolean);
begin
  Mapi.Attachments.Add(AnsiString(AFullFileName));
end;

//------------------------------------------------------------------------------

procedure TfrmJclMapi.DIHtmlMimeMessage1End(
  const AHtmlBuffer: Pointer;
  const AHtmlBufferSize: Cardinal);
var
  s: AnsiString;
begin
  SetString(s, PAnsiChar(AHtmlBuffer), AHtmlBufferSize);
  Mapi.Body := s;
end;

end.

